<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\Url;
use yii\widgets\MaskedInput;

$this->title = 'Регистрация';
$this->params['breadcrumbs'][] = $this->title;

$this->registerJs("
// Маска для телефона
document.getElementById('registerform-phone').addEventListener('input', function(e) {
    var x = e.target.value.replace(/\\D/g, '').match(/(\\d{0,1})(\\d{0,3})(\\d{0,3})(\\d{0,2})(\\d{0,2})/);
    e.target.value = !x[2] ? x[1] : '+7(' + x[2] + (x[3] ? ')' + x[3] : '') + (x[4] ? '-' + x[4] : '') + (x[5] ? '-' + x[5] : '');
});

// Валидация пароля
function validatePassword() {
    var password = document.getElementById('registerform-password').value;
    var passwordRepeat = document.getElementById('registerform-password_repeat').value;
    var errorElement = document.getElementById('password-error');
    
    if (password.length < 7) {
        errorElement.textContent = 'Пароль должен содержать минимум 7 символов';
        return false;
    }
    
    if (password !== passwordRepeat) {
        errorElement.textContent = 'Пароли не совпадают';
        return false;
    }
    
    errorElement.textContent = '';
    return true;
}

// Валидация ФИО
function validateFullName() {
    var fullName = document.getElementById('registerform-full_name').value;
    var errorElement = document.getElementById('fullname-error');
    var regex = /^[а-яА-ЯёЁ\\s\\-]+$/u;
    
    if (!regex.test(fullName)) {
        errorElement.textContent = 'ФИО должно содержать только русские буквы, пробелы и дефисы';
        return false;
    }
    
    errorElement.textContent = '';
    return true;
}

// Обработка отправки формы
document.getElementById('register-form').addEventListener('submit', function(e) {
    if (!validateFullName() || !validatePassword()) {
        e.preventDefault();
        return false;
    }
    
    // Анимация кнопки
    var btn = document.getElementById('register-button');
    btn.innerHTML = '<span style=\"display:inline-block;width:20px;height:20px;border:2px solid #fff;border-radius:50%;border-top-color:transparent;animation:spin 1s linear infinite;\"></span> Регистрация...';
    btn.disabled = true;
    
    setTimeout(function() {
        btn.innerHTML = 'Создать пользователя';
        btn.disabled = false;
    }, 3000);
});

// Стили для спиннера
var style = document.createElement('style');
style.textContent = '@keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }';
document.head.appendChild(style);
");
?>

<div class="site-register">
    <div class="card">
        <h1 class="text-center" style="margin-bottom: 30px; color: #3949ab;">
            <span style="font-size: 2.5rem;">📝</span><br>
            Регистрация
        </h1>
        
        <?php $form = ActiveForm::begin([
            'id' => 'register-form',
            'enableClientValidation' => true,
            'enableAjaxValidation' => false,
            'options' => ['class' => 'form'],
            'fieldConfig' => [
                'template' => "{label}\n{input}\n{error}",
                'labelOptions' => ['class' => 'form-label'],
                'inputOptions' => ['class' => 'form-control'],
                'errorOptions' => ['class' => 'error-message', 'id' => '{id}-error'],
            ],
        ]); ?>

        <div class="row">
            <div class="col-12">
                <?= $form->field($model, 'full_name', [
                    'inputOptions' => [
                        'placeholder' => 'Иванов Иван Иванович',
                        'autofocus' => true,
                        'onblur' => 'validateFullName()'
                    ]
                ])->textInput() ?>
            </div>
        </div>

        <div class="row">
            <div class="col-6">
                <?= $form->field($model, 'email', [
                    'inputOptions' => [
                        'type' => 'email',
                        'placeholder' => 'name@example.com'
                    ]
                ])->textInput() ?>
            </div>
            
            <div class="col-6">
                <?= $form->field($model, 'phone', [
                    'inputOptions' => [
                        'placeholder' => '+7(999)999-99-99',
                        'id' => 'registerform-phone'
                    ]
                ])->textInput() ?>
            </div>
        </div>

        <div class="row">
            <div class="col-6">
                <?= $form->field($model, 'password', [
                    'inputOptions' => [
                        'placeholder' => 'Минимум 7 символов',
                        'onblur' => 'validatePassword()'
                    ]
                ])->passwordInput() ?>
            </div>
            
            <div class="col-6">
                <?= $form->field($model, 'password_repeat', [
                    'inputOptions' => [
                        'placeholder' => 'Повторите пароль',
                        'onblur' => 'validatePassword()'
                    ]
                ])->passwordInput() ?>
            </div>
        </div>

        <div class="form-group" style="margin: 30px 0;">
            <div style="display: flex; align-items: center; gap: 10px;">
                <?= $form->field($model, 'agree', [
                    'template' => "{input} {label}",
                    'options' => ['style' => 'margin: 0;'],
                    'inputOptions' => [
                        'style' => 'width: 20px; height: 20px; margin: 0;',
                        'id' => 'agree'
                    ],
                    'labelOptions' => [
                        'style' => 'font-weight: normal; margin: 0; cursor: pointer;',
                        'for' => 'agree'
                    ]
                ])->checkbox([
                    'uncheck' => null,
                    'label' => 'Я согласен с правилами регистрации и обработкой персональных данных'
                ]) ?>
            </div>
        </div>

        <div class="form-group" style="margin-top: 40px;">
            <?= Html::submitButton('Создать пользователя', [
                'class' => 'btn btn-primary btn-block',
                'name' => 'register-button',
                'id' => 'register-button',
                'style' => 'padding: 15px; font-size: 18px;'
            ]) ?>
        </div>

        <?php ActiveForm::end(); ?>

        <div style="text-align: center; margin-top: 30px; padding-top: 20px; border-top: 1px solid #eee;">
            <p style="margin-bottom: 15px; color: #666;">Уже есть аккаунт?</p>
            <?= Html::a('Войти в систему', ['site/login'], [
                'class' => 'btn',
                'style' => 'background: #78909c; color: white; padding: 10px 30px;'
            ]) ?>
        </div>
    </div>
    
    <div style="text-align: center; margin-top: 30px;">
        <p style="color: #666; font-size: 14px;">
            Регистрируясь, вы соглашаетесь с 
            <a href="#" onclick="showPrivacyModal()" style="color: #3949ab; text-decoration: none; border-bottom: 1px dashed #3949ab;">
                правилами обработки персональных данных
            </a>
        </p>
    </div>
</div>

<div id="privacy-modal" style="display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.5); z-index: 10000; align-items: center; justify-content: center;">
    <div style="background: white; max-width: 600px; width: 90%; border-radius: 10px; padding: 30px; position: relative;">
        <button onclick="hidePrivacyModal()" style="position: absolute; top: 15px; right: 15px; background: none; border: none; font-size: 24px; cursor: pointer; color: #666;">×</button>
        
        <h3 style="color: #3949ab; margin-bottom: 20px;">Правила обработки персональных данных</h3>
        
        <div style="line-height: 1.8;">
            <p><strong>1. Общие положения</strong><br>
            Все персональные данные обрабатываются в соответствии с Федеральным законом №152-ФЗ "О персональных данных".</p>
            
            <p><strong>2. Цель обработки</strong><br>
            Данные используются исключительно для целей системы отдела кадров организации.</p>
            
            <p><strong>3. Конфиденциальность</strong><br>
            Мы гарантируем конфиденциальность ваших данных. Доступ имеют только уполномоченные сотрудники.</p>
            
            <p><strong>4. Права пользователя</strong><br>
            Вы можете в любой момент запросить информацию о своих данных или потребовать их удаления.</p>
        </div>
        
        <div style="text-align: center; margin-top: 30px;">
            <button onclick="hidePrivacyModal()" class="btn" style="background: #3949ab; color: white; padding: 10px 30px;">Понятно</button>
        </div>
    </div>
</div>

<script>
function showPrivacyModal() {
    document.getElementById('privacy-modal').style.display = 'flex';
    document.body.style.overflow = 'hidden';
}

function hidePrivacyModal() {
    document.getElementById('privacy-modal').style.display = 'none';
    document.body.style.overflow = 'auto';
}

// Закрытие по клику вне модального окна
document.getElementById('privacy-modal').addEventListener('click', function(e) {
    if (e.target === this) {
        hidePrivacyModal();
    }
});
</script>