<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Авторизация';
$this->params['breadcrumbs'][] = $this->title;

$this->registerCss("
.login-card {
    max-width: 500px;
    margin: 0 auto;
    animation: slideIn 0.6s ease-out;
}

@keyframes slideIn {
    from { opacity: 0; transform: translateY(-30px); }
    to { opacity: 1; transform: translateY(0); }
}

.form-header {
    text-align: center;
    margin-bottom: 40px;
}

.form-header h1 {
    color: #3949ab;
    margin-bottom: 10px;
}

.form-header p {
    color: #666;
    font-size: 16px;
}

.forgot-link {
    color: #3949ab;
    text-decoration: none;
    font-size: 14px;
}

.forgot-link:hover {
    text-decoration: underline;
}

.test-accounts {
    background: #f5f5f5;
    border-radius: 8px;
    padding: 20px;
    margin-top: 30px;
    font-size: 14px;
}

.test-accounts h4 {
    color: #3949ab;
    margin-bottom: 10px;
}

.test-accounts p {
    margin: 5px 0;
    color: #666;
}
");

$this->registerJs("
// Обработка отправки формы
document.getElementById('login-form').addEventListener('submit', function(e) {
    // Анимация кнопки
    var btn = document.getElementById('login-button');
    var originalText = btn.innerHTML;
    
    btn.innerHTML = '<span style=\"display:inline-block;width:20px;height:20px;border:2px solid #fff;border-radius:50%;border-top-color:transparent;animation:spin 1s linear infinite;margin-right:8px;\"></span>Вход...';
    btn.disabled = true;
    
    // Автоматически восстановим кнопку через 3 секунды на случай ошибки
    setTimeout(function() {
        btn.innerHTML = originalText;
        btn.disabled = false;
    }, 3000);
});

// Добавляем анимацию для полей ввода
var inputs = document.querySelectorAll('.form-control');
inputs.forEach(function(input) {
    input.addEventListener('focus', function() {
        this.parentElement.style.transform = 'translateY(-2px)';
    });
    
    input.addEventListener('blur', function() {
        this.parentElement.style.transform = 'translateY(0)';
    });
});
");
?>

<div class="site-login">
    <div class="card login-card">
        <div class="form-header">
            <h1><span style="font-size: 2.5rem;">🔐</span><br>Вход в систему</h1>
            <p>Введите данные для входа в систему отдела кадров</p>
        </div>

        <?php $form = ActiveForm::begin([
            'id' => 'login-form',
            'options' => ['class' => 'form'],
            'fieldConfig' => [
                'template' => "{label}\n{input}\n{error}",
                'labelOptions' => ['class' => 'form-label'],
                'inputOptions' => ['class' => 'form-control'],
                'errorOptions' => ['class' => 'error-message'],
            ],
        ]); ?>

        <?= $form->field($model, 'email', [
            'inputOptions' => [
                'placeholder' => 'name@example.com',
                'type' => 'email',
                'autofocus' => true
            ]
        ])->textInput() ?>

        <?= $form->field($model, 'password', [
            'inputOptions' => [
                'placeholder' => 'Введите пароль'
            ]
        ])->passwordInput() ?>

        <div style="display: flex; justify-content: space-between; align-items: center; margin: 25px 0;">
            <div style="display: flex; align-items: center;">
                <?= $form->field($model, 'rememberMe', [
                    'template' => "{input} {label}",
                    'options' => ['style' => 'margin: 0;'],
                    'inputOptions' => [
                        'style' => 'width: 20px; height: 20px; margin-right: 8px;',
                        'id' => 'rememberMe'
                    ],
                    'labelOptions' => [
                        'style' => 'font-weight: normal; margin: 0; cursor: pointer;',
                        'for' => 'rememberMe'
                    ]
                ])->checkbox(['label' => 'Запомнить меня']) ?>
            </div>
            
            <div>
                <?= Html::a('Забыли пароль?', '#', [
                    'class' => 'forgot-link',
                    'onclick' => "alert('Для восстановления пароля обратитесь к администратору.')"
                ]) ?>
            </div>
        </div>

        <div style="margin-top: 30px;">
            <?= Html::submitButton('Войти', [
                'class' => 'btn btn-primary btn-block',
                'name' => 'login-button',
                'id' => 'login-button',
                'style' => 'padding: 15px; font-size: 18px;'
            ]) ?>
        </div>

        <?php ActiveForm::end(); ?>

        <div style="text-align: center; margin-top: 30px; padding-top: 25px; border-top: 1px solid #eee;">
            <p style="margin-bottom: 15px; color: #666;">Еще не зарегистрированы?</p>
            <?= Html::a('Создать аккаунт', ['site/register'], [
                'class' => 'btn',
                'style' => 'background: #78909c; color: white; padding: 10px 30px;'
            ]) ?>
        </div>

        <div class="test-accounts">
            <h4>Тестовые аккаунты:</h4>
            <p><strong>Администратор:</strong><br>
            Email: admin@mail.ru<br>
            Пароль: adminka</p>
            
            <p><strong>Сотрудник:</strong><br>
            Email: test@mail.ru<br>
            Пароль: password123</p>
        </div>
    </div>
</div>