<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Личный кабинет';
$this->params['breadcrumbs'][] = $this->title;

$this->registerCss("
.profile-container {
    max-width: 1000px;
    margin: 0 auto;
}

.welcome-card {
    background: linear-gradient(135deg, #3949ab 0%, #5c6bc0 100%);
    color: white;
    border-radius: 15px;
    padding: 40px;
    margin-bottom: 40px;
    text-align: center;
    box-shadow: 0 10px 30px rgba(57, 73, 171, 0.3);
    animation: fadeIn 0.8s ease-out;
}

.welcome-card h1 {
    font-size: 2.5rem;
    margin-bottom: 10px;
}

.welcome-card p {
    font-size: 1.2rem;
    opacity: 0.9;
    margin-bottom: 20px;
}

.status-badge {
    display: inline-block;
    padding: 8px 20px;
    border-radius: 20px;
    font-weight: bold;
    font-size: 14px;
    margin: 10px 0;
}

.status-new {
    background: #ff9800;
    color: white;
}

.status-review {
    background: #2196f3;
    color: white;
}

.status-accepted {
    background: #4caf50;
    color: white;
}

.actions-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin: 40px 0;
}

.action-card {
    background: white;
    border-radius: 10px;
    padding: 30px;
    text-align: center;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
    animation: slideUp 0.6s ease-out;
}

.action-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.15);
}

.action-icon {
    font-size: 3rem;
    margin-bottom: 20px;
    display: block;
}

.action-card h3 {
    color: #3949ab;
    margin-bottom: 15px;
}

.action-card p {
    color: #666;
    margin-bottom: 20px;
    font-size: 14px;
}

.info-card {
    background: white;
    border-radius: 10px;
    padding: 30px;
    margin-bottom: 30px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    animation: slideUp 0.6s ease-out;
}

.info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-top: 20px;
}

.info-item {
    padding: 15px;
    background: #f8f9fa;
    border-radius: 8px;
    border-left: 4px solid #3949ab;
}

.info-label {
    font-size: 12px;
    color: #666;
    text-transform: uppercase;
    margin-bottom: 5px;
}

.info-value {
    font-weight: bold;
    color: #333;
}

.empty-state {
    text-align: center;
    padding: 60px 30px;
    background: #f8f9fa;
    border-radius: 10px;
    margin: 40px 0;
}

.empty-state-icon {
    font-size: 4rem;
    color: #bbb;
    margin-bottom: 20px;
}

@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

@keyframes slideUp {
    from { opacity: 0; transform: translateY(30px); }
    to { opacity: 1; transform: translateY(0); }
}
");
?>

<div class="profile-container">
    <div class="welcome-card">
        <h1>👋 Добро пожаловать, <?= Html::encode($user->full_name) ?>!</h1>
        <p>Личный кабинет сотрудника системы отдела кадров</p>
        
        <?php if ($profile): ?>
            <?php 
            $statusClass = '';
            switch ($profile->status) {
                case 'new': $statusClass = 'status-new'; break;
                case 'in_review': $statusClass = 'status-review'; break;
                case 'accepted': $statusClass = 'status-accepted'; break;
            }
            ?>
            <div class="status-badge <?= $statusClass ?>">
                Статус анкеты: <?= $profile->getStatusName() ?>
            </div>
        <?php endif; ?>
    </div>

    <?php if (!$profile): ?>
        <div class="empty-state">
            <div class="empty-state-icon">📋</div>
            <h2 style="color: #666; margin-bottom: 15px;">Анкета не заполнена</h2>
            <p style="color: #888; margin-bottom: 30px; max-width: 500px; margin-left: auto; margin-right: auto;">
                Для работы в системе необходимо заполнить анкету сотрудника. 
                Это займет всего несколько минут.
            </p>
            <?= Html::a('Заполнить анкету', ['create'], [
                'class' => 'btn',
                'style' => 'background: #3949ab; color: white; padding: 12px 40px; font-size: 16px;'
            ]) ?>
        </div>
    <?php else: ?>
        <div class="actions-grid">
            <div class="action-card">
                <span class="action-icon">👁️</span>
                <h3>Просмотр анкеты</h3>
                <p>Просмотрите все введенные данные вашей анкеты</p>
                <?= Html::a('Просмотреть', ['view'], [
                    'class' => 'btn',
                    'style' => 'background: #2196f3; color: white; padding: 10px 25px;'
                ]) ?>
            </div>
            
            <div class="action-card">
                <span class="action-icon">✏️</span>
                <h3>Редактирование</h3>
                <p>Внесите изменения в данные вашей анкеты</p>
                <?= Html::a('Редактировать', ['update'], [
                    'class' => 'btn',
                    'style' => 'background: #ff9800; color: white; padding: 10px 25px;'
                ]) ?>
            </div>
            
            <div class="action-card">
                <span class="action-icon">📧</span>
                <h3>Контактные данные</h3>
                <p>Ваши контакты для связи</p>
                <?= Html::a('Показать', '#contact-info', [
                    'class' => 'btn',
                    'style' => 'background: #4caf50; color: white; padding: 10px 25px;',
                    'onclick' => "document.getElementById('contact-info').scrollIntoView({behavior: 'smooth'});"
                ]) ?>
            </div>
        </div>

        <div class="info-card">
            <h2 style="color: #3949ab; margin-bottom: 25px;">📊 Краткая информация</h2>
            
            <div class="info-grid">
                <div class="info-item">
                    <div class="info-label">Должность</div>
                    <div class="info-value"><?= $profile->position ? Html::encode($profile->position) : 'Не указана' ?></div>
                </div>
                
                <div class="info-item">
                    <div class="info-label">Место работы</div>
                    <div class="info-value"><?= $profile->workplace ? Html::encode($profile->workplace) : 'Не указано' ?></div>
                </div>
                
                <div class="info-item">
                    <div class="info-label">Образование</div>
                    <div class="info-value"><?= $profile->getEducationName() ?></div>
                </div>
                
                <div class="info-item">
                    <div class="info-label">Стаж</div>
                    <div class="info-value"><?= $profile->getExperienceFormatted() ?></div>
                </div>
                
                <div class="info-item">
                    <div class="info-label">Дата заполнения</div>
                    <div class="info-value"><?= Yii::$app->formatter->asDate($profile->created_at) ?></div>
                </div>
                
                <div class="info-item">
                    <div class="info-label">Последнее обновление</div>
                    <div class="info-value"><?= Yii::$app->formatter->asDate($profile->updated_at) ?></div>
                </div>
            </div>
        </div>

        <div id="contact-info" class="info-card">
            <h2 style="color: #3949ab; margin-bottom: 25px;">📞 Контактные данные</h2>
            
            <div class="info-grid">
                <div class="info-item">
                    <div class="info-label">ФИО</div>
                    <div class="info-value"><?= Html::encode($user->full_name) ?></div>
                </div>
                
                <div class="info-item">
                    <div class="info-label">Email</div>
                    <div class="info-value"><?= Html::encode($user->email) ?></div>
                </div>
                
                <div class="info-item">
                    <div class="info-label">Телефон</div>
                    <div class="info-value"><?= Html::encode($user->phone) ?></div>
                </div>
                
                <?php if ($profile->birth_date): ?>
                <div class="info-item">
                    <div class="info-label">Дата рождения</div>
                    <div class="info-value"><?= Yii::$app->formatter->asDate($profile->birth_date) ?></div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>
    
    <div class="info-card" style="background: #f8f9fa;">
        <h3 style="color: #666; margin-bottom: 15px;">💡 Важная информация</h3>
        <ul style="color: #666; line-height: 1.8;">
            <li>После заполнения анкета отправляется на проверку администратору</li>
            <li>Статус проверки можно отслеживать в личном кабинете</li>
            <li>После принятия анкеты изменения возможны только через администратора</li>
            <li>Все данные защищены и конфиденциальны</li>
        </ul>
    </div>
</div>