<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%employee_profile}}`.
 */
class m260206_162734_create_employee_profile_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%employee_profile}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            
            // Личные данные
            'photo' => $this->string(500),
            'birth_date' => $this->date(),
            'gender' => $this->string(10)->comment('male, female'),
            'citizenship' => $this->string(100),
            
            // Паспортные данные
            'passport_series' => $this->string(10),
            'passport_number' => $this->string(20),
            'passport_issued_by' => $this->text(),
            'passport_issue_date' => $this->date(),
            'passport_registration' => $this->text(),
            'passport_scan' => $this->string(500),
            'marital_status' => $this->string(50)->comment('single, married, divorced, widowed'),
            
            // Образование
            'education' => $this->string(100)->comment('basic, secondary, vocational, higher'),
            'education_organization' => $this->string(255),
            'specialty' => $this->text(),
            'qualification' => $this->text(),
            'diploma_number' => $this->string(100),
            'diploma_scan' => $this->string(500),
            
            // Работа
            'workplace' => $this->string(255),
            'position' => $this->string(255),
            'experience' => $this->integer()->comment('Стаж в месяцах'),
            
            // Прочие данные
            'snils' => $this->string(20),
            'snils_scan' => $this->string(500),
            'health_status' => $this->text(),
            'additional_info' => $this->text(),
            
            // Статус анкеты
            'status' => $this->string(20)->defaultValue('new')->comment('new, in_review, accepted'),
            'reviewed_by' => $this->integer(),
            'reviewed_at' => $this->integer(),
            'review_comment' => $this->text(),
            
            // Даты
            'created_at' => $this->integer()->notNull(),
            'updated_at' => $this->integer()->notNull(),
        ], $tableOptions);

        // Внешний ключ и индексы
        $this->addForeignKey(
            'fk-employee_profile-user_id',
            '{{%employee_profile}}',
            'user_id',
            '{{%user}}',
            'id',
            'CASCADE',
            'CASCADE'
        );

        $this->createIndex('idx-profile-user_id', '{{%employee_profile}}', 'user_id');
        $this->createIndex('idx-profile-status', '{{%employee_profile}}', 'status');
        $this->createIndex('idx-profile-gender', '{{%employee_profile}}', 'gender');
        $this->createIndex('idx-profile-citizenship', '{{%employee_profile}}', 'citizenship');
        $this->createIndex('idx-profile-education', '{{%employee_profile}}', 'education');
        $this->createIndex('idx-profile-position', '{{%employee_profile}}', 'position');
        $this->createIndex('idx-profile-marital_status', '{{%employee_profile}}', 'marital_status');
    }


    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%employee_profile}}');
    }
}
